package com.ejie.ab04b.dao;

import java.util.List;

import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * ComunicacionAperturaCustomDao generated by UDA, 26-dic-2016 13:08:26.
 * 
 * @author UDA
 */

public interface ComunicacionAperturaCustomDao extends ComunicacionAperturaDao {

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> vistaFindAllLike(ComunicacionApertura ab04b56s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 startsWith Boolean Long
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	Long vistaFindAllLikeCount(ComunicacionApertura ab04b56s00,
			Boolean startsWith);

	/**
	 * Vista find detalle.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * filtro ComunicacionApertura HExpediente
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura vistaFindDetalle(ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto, ComunicacionApertura filtro);

	/**
	 * Finds a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura vFind(ComunicacionApertura comunicApertura);

	/**
	 * Finds a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura vFindDetalle(ComunicacionApertura comunicApertura);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findListadoAnualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	Long findListadoAnualMesTerCount(ComunicacionApertura filtro,
			Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findListadoBianualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findListadoAnualSecTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	Long findListadoAnualSecTerCount(ComunicacionApertura filtro,
			Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findListadoSinInfoOsalan(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	Long findListadoSinInfoOsalanCount(ComunicacionApertura filtro,
			Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findListadoSubsanacion(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	Long findListadoSubsanacionCount(ComunicacionApertura filtro,
			Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findNumberAperturaTrab(
			ComunicacionApertura filtro, Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findNumberAperturaTrabPorCentro(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	Long findNumberAperturaTrabPorCentroCount(ComunicacionApertura filtro,
			Boolean startsWith);

	/**
	 * Obtiene una lista con todos los numeros de apertura por por tramos de
	 * trabajador.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto List
	 * <ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	List<ComunicacionApertura> findNumberAperturaTrabPorTrabajadores(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto);

	/**
	 * Obtiene una lista con todos los numeros de apertura por por tramos de
	 * trabajador.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto List
	 * <ComunicacionApertura>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	Long findNumberAperturaTrabPorTrabajadoresCount(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Devuelve los datos de notificacion de un expediente.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean ComunicacionApertura
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> obtenerDatosEtiquetas(
			ComunicacionApertura filtro, Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * filtro ComunicacionApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> listadoFindAllLike(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto, boolean startsWith);

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * comunicacionApertura ComunicacionApertura b Boolean Long
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param b
	 *            the b
	 * @return the long
	 */
	Long listadoFindAllLikeCount(ComunicacionApertura comunicacionApertura,
			boolean b);

}
